/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSamplingSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSliderBuilder;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.apache.commons.lang3.StringUtils;

public class CommandRefreshChunks
implements Command<CommandSourceStack> {
    private static final CommandRefreshChunks CMD = new CommandRefreshChunks();
    public static final String XZSCALE = "xzscale";
    public static final String YSCALE = "yscale";
    public static final String XZFACTOR = "xzfactor";
    public static final String YFACTOR = "yfactor";
    public static final String TOPOFFSET = "topoffset";
    public static final String TOPSIZE = "topsize";
    public static final String TOPTARGET = "toptarget";
    public static final String BOTTOMOFFSET = "bottomoffset";
    public static final String BOTTOMSIZE = "bottomsize";
    public static final String BOTTOMTARGET = "bottomtarget";
    public static final String HORIZONTAL = "horizontal";
    public static final String VERTICAL = "vertical";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"refreshchunks").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"par", (ArgumentType)StringArgumentType.string()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SharedConstants.f_136183_ = true;
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        if (chunkGenerator instanceof RFToolsChunkGenerator) {
            RFToolsChunkGenerator chunkGenerator2 = (RFToolsChunkGenerator)chunkGenerator;
            String par = (String)context.getArgument("par", String.class);
            String[] split = StringUtils.split((String)par, (char)'=');
            String cmd = split[0].toLowerCase();
            NoiseGeneratorSettings settings = chunkGenerator2.getNoiseGeneratorSettings();
            if ("list".equals(cmd)) {
                this.dump(settings);
            } else if (split.length <= 1) {
                double result = switch (cmd) {
                    case XZSCALE -> settings.f_64439_().f_64509_().f_64491_();
                    case YSCALE -> settings.f_64439_().f_64509_().f_64492_();
                    case XZFACTOR -> settings.f_64439_().f_64509_().f_64493_();
                    case YFACTOR -> settings.f_64439_().f_64509_().f_64494_();
                    case TOPOFFSET -> settings.f_64439_().f_64510_().f_189226_();
                    case TOPSIZE -> settings.f_64439_().f_64510_().f_189225_();
                    case TOPTARGET -> settings.f_64439_().f_64510_().f_189224_();
                    case BOTTOMOFFSET -> settings.f_64439_().f_64511_().f_189226_();
                    case BOTTOMSIZE -> settings.f_64439_().f_64511_().f_189225_();
                    case BOTTOMTARGET -> settings.f_64439_().f_64511_().f_189224_();
                    case HORIZONTAL -> settings.f_64439_().f_64512_();
                    case VERTICAL -> settings.f_64439_().f_64513_();
                    default -> 0.0;
                };
                System.out.println(cmd + " = " + result);
            } else {
                double doubleValue = CommandRefreshChunks.asDouble(split[1]);
                int intValue = CommandRefreshChunks.asInt(split[1]);
                Consumer<NoiseSettingsBuilder> noiseBuilder = switch (cmd) {
                    case HORIZONTAL -> builder -> builder.noiseSizeHorizontal(intValue);
                    case VERTICAL -> builder -> builder.noiseSizeVertical(intValue);
                    default -> builder -> {};
                };
                Consumer<NoiseSamplingSettingsBuilder> samplingBuilder = switch (cmd) {
                    case XZSCALE -> builder -> builder.xzScale(doubleValue);
                    case YSCALE -> builder -> builder.yScale(doubleValue);
                    case XZFACTOR -> builder -> builder.xzFactor(doubleValue);
                    case YFACTOR -> builder -> builder.yFactor(doubleValue);
                    default -> builder -> {};
                };
                Consumer<NoiseSliderBuilder> topSliderBuilder = switch (cmd) {
                    case TOPOFFSET -> builder -> builder.offset(intValue);
                    case TOPSIZE -> builder -> builder.size(intValue);
                    case TOPTARGET -> builder -> builder.top(doubleValue);
                    default -> builder -> {};
                };
                Consumer<NoiseSliderBuilder> bottomSliderBuilder = switch (cmd) {
                    case BOTTOMOFFSET -> builder -> builder.offset(intValue);
                    case BOTTOMSIZE -> builder -> builder.size(intValue);
                    case BOTTOMTARGET -> builder -> builder.top(doubleValue);
                    default -> builder -> {};
                };
                chunkGenerator2.changeSettings(noiseBuilder, samplingBuilder, topSliderBuilder, bottomSliderBuilder);
            }
        }
        return 0;
    }

    private void dump(NoiseGeneratorSettings settings) {
        NoiseSettings noiseSettings = settings.f_64439_();
        System.out.println("Noise settings:");
        NoiseSamplingSettings samplingSettings = noiseSettings.f_64509_();
        System.out.println("    SamplingSettings:   xzfactor=" + samplingSettings.f_64493_() + "  yfactor=" + samplingSettings.f_64494_() + "  xzscale=" + samplingSettings.f_64491_() + "  yscale=" + samplingSettings.f_64492_());
        System.out.println("    TopSlider:  toptarget=" + noiseSettings.f_64510_().f_189224_() + "  topsize=" + noiseSettings.f_64510_().f_189225_() + "  topoffset=" + noiseSettings.f_64510_().f_189226_());
        System.out.println("    BottomSlider:  bottomtarget=" + noiseSettings.f_64511_().f_189224_() + "  bottomsize=" + noiseSettings.f_64511_().f_189225_() + "  bottomoffset=" + noiseSettings.f_64511_().f_189226_());
        System.out.println("    horizontal=" + noiseSettings.f_64512_() + "  vertical=" + noiseSettings.f_64513_());
    }

    private static double asDouble(String d) {
        try {
            return Double.parseDouble(d);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static int asInt(String d) {
        try {
            return Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

